---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：16-Snapshots Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行67-69（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行77-96（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行78-79（repository, ALL_SNAPSHOTS）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行81（ignore_unavailable）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行104-119（テーブルヘッダー定義12カラム）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行117（reason default:false）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行121（FORMATTER HH:mm:ss UTC）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行123-151（buildTable処理）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行130（TimeUnit.SECONDS.convert）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行134-139（duration計算、IN_PROGRESS判定）
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` 行140（TimeValue.timeValueMillis）
- E-12: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行17（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/snapshots と /_cat/snapshots/{repository} | E-01 | ○ |
| C-02 | GetSnapshotsRequest で ALL_SNAPSHOTS 指定 | E-03 | ○ |
| C-03 | ignore_unavailable パラメータ対応 | E-04 | ○ |
| C-04 | テーブルカラムは12個 | E-05 | ○ |
| C-05 | reason はデフォルト非表示 | E-06 | ○ |
| C-06 | 時刻フォーマットは HH:mm:ss UTC | E-07 | ○ |
| C-07 | start_epochはミリ秒から秒への変換 | E-09 | ○ |
| C-08 | IN_PROGRESS時のduration = now - startTime | E-10 | ○ |
| C-09 | それ以外のduration = endTime - startTime | E-10 | ○ |
| C-10 | durationはTimeValue形式 | E-11 | ○ |
| C-11 | id aliasは snapshot | E-05 | ○ |
| C-12 | status aliasは s | E-05 | ○ |
| C-13 | duration aliasは dur | E-05 | ○ |
| C-14 | indices aliasは i | E-05 | ○ |
| C-15 | SnapshotInfo.state()で状態取得 | E-08 | ○ |
| C-16 | SnapshotInfo.indices().size()でインデックス数取得 | E-08 | ○ |
| C-17 | SnapshotInfo.successfulShards()で成功シャード数取得 | E-08 | ○ |
| C-18 | SnapshotInfo.reason()で失敗理由取得 | E-08 | ○ |
| C-19 | アクション名は cat_snapshot_action | E-01 | ○ |
| C-20 | ソースファイルは全152行 | E-08 | ○ |
| C-21 | 帳票名は「Snapshots Report」 | E-12 | ○ |
| C-22 | cluster:admin/snapshot/get 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・duration計算ロジック（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラム12個の定義が正確か確認
- [ ] duration計算のIN_PROGRESS判定ロジック確認
- [ ] セキュリティ権限名の確認
